//
//  KeychainSearch.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import "Keychain.h"


@interface SearchAttribute : NSObject {
    SecKeychainAttribute attribute;
    BOOL freeWhenDone;
}

+ (SearchAttribute*)attributeWithTag:(SecKeychainAttrType)tag length:(UInt32)length data:(void*)data freeWhenDone:(BOOL)fre;
+ (SearchAttribute*)attributeWithTag:(SecKeychainAttrType)tag length:(UInt32)length data:(const void *)data;

- (SearchAttribute*)initWithTag:(SecKeychainAttrType)tag length:(UInt32)length data:(void*)data freeWhenDone:(BOOL)fre;
- (SearchAttribute*)initWithTag:(SecKeychainAttrType)tag length:(UInt32)length data:(const void *)data;

- (SecKeychainAttributePtr)attributePtr;

@end



@interface KeychainSearch : NSObject {
    Keychain *keychain;
    NSMutableArray *attributes;
    int error;
}

+ (KeychainSearch*)keychainSearchWithKeychain:(Keychain*)keych;

- (KeychainSearch*)initWithKeychain:(Keychain*)keych;

- (void)setCreationDate:(NSDate*)date;
- (void)setModificationDate:(NSDate*)date;
- (void)setDescription:(NSString*)desc;
- (void)setComment:(NSString*)comment;
- (void)setCreator:(NSString*)creator;
- (void)setType:(NSString*)type;
- (void)setLabel:(NSString*)label;
- (void)setIsVisible:(BOOL)visible;
- (void)setPasswordIsValid:(BOOL)valid;
- (void)setHasCustomIcon:(BOOL)customIcon;
- (void)setAccount:(NSString*)account;
- (void)setService:(NSString*)service;
- (void)setAttribute:(NSString*)attr;
- (void)setDomain:(NSString*)domain;
- (void)setServer:(NSString*)server;
- (void)setAuthenticationType:(SecAuthenticationType)type;
- (void)setPort:(UInt16)port;
- (void)setPath:(NSString*)path;
- (void)setAppleShareVolume:(NSString*)volume;
- (void)setAppleShareAddress:(NSString*)address;
- (void)setAppleShareSignature:(SecAFPServerSignature*)sig;
- (void)setProtocol:(SecProtocolType)protocol;
- (void)setCertificateType:(CSSM_CERT_TYPE)type;
- (void)setCertificateEncoding:(CSSM_CERT_ENCODING)encoding;
- (void)setCRLType:(CSSM_CRL_TYPE)type;
- (void)setCRLEncoding:(CSSM_CRL_ENCODING)encoding;
- (void)setIsAlias:(BOOL)alias;

- (NSArray*)searchResultsForClass:(SecItemClass)class;

- (NSArray*)anySearchResults;
- (NSArray*)genericSearchResults;
- (NSArray*)internetSearchResults;
- (NSArray*)appleShareSearchResults;
- (NSArray*)certificateSearchResults;

- (int)lastError;
- (Keychain*)keychain;

@end
